/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.handlers;

import java.time.LocalDate;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.handlers.CommonJetpackHandler;
import stormedpanda.simplyjetpacks.item.JetpackItem;
import stormedpanda.simplyjetpacks.item.PotatoJetpackItem;
import stormedpanda.simplyjetpacks.particle.JetpackParticleType;
import stormedpanda.simplyjetpacks.sound.JetpackSound;
import stormedpanda.simplyjetpacks.util.JetpackUtil;
import stormedpanda.simplyjetpacks.util.Pos3D;

@OnlyIn(value=Dist.CLIENT)
public class ClientJetpackHandler {
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && minecraft.field_71439_g != null && minecraft.field_71441_e != null && !minecraft.func_147113_T() && !minecraft.field_71439_g.func_175149_v()) {
            ItemStack chest = JetpackUtil.getFromBothSlots((PlayerEntity)minecraft.field_71439_g);
            Item item = chest.func_77973_b();
            if (!chest.func_190926_b() && item instanceof JetpackItem && ClientJetpackHandler.isFlying((PlayerEntity)minecraft.field_71439_g) || item instanceof PotatoJetpackItem && ((PotatoJetpackItem)item).isFired(chest)) {
                JetpackParticleType particleType;
                if (((Boolean)SimplyJetpacksConfig.enableJetpackParticles.get()).booleanValue() && minecraft.field_71474_y.field_74362_aa != ParticleStatus.MINIMAL && (particleType = minecraft.field_71439_g.func_203008_ap() ? JetpackParticleType.BUBBLES : (ClientJetpackHandler.checkValentines() ? JetpackParticleType.HEARTS : JetpackParticleType.values()[JetpackItem.getParticleId(chest)])).getParticleData() != null) {
                    this.showJetpackParticles(minecraft, particleType);
                }
                if (((Boolean)SimplyJetpacksConfig.enableJetpackSounds.get()).booleanValue() && !JetpackSound.playing(minecraft.field_71439_g.func_145782_y())) {
                    minecraft.func_147118_V().func_147682_a((ISound)new JetpackSound((PlayerEntity)minecraft.field_71439_g));
                }
            }
        }
    }

    private void showJetpackParticles(Minecraft minecraft, JetpackParticleType particleType) {
        double[] dArray;
        IParticleData particle = particleType.getParticleData();
        Random rand = new Random();
        float random = (rand.nextFloat() - 0.5f) * 0.1f;
        if (minecraft.field_71439_g.func_213453_ef()) {
            double[] dArray2 = new double[2];
            dArray2[0] = -0.3;
            dArray = dArray2;
            dArray2[1] = -0.1;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        }
        double[] sneakBonus = dArray;
        Pos3D playerPos = new Pos3D((Entity)minecraft.field_71439_g).translate(0.0, 1.5, 0.0);
        Pos3D vLeft = new Pos3D(-0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.field_71439_g.field_70761_aq, 0.0f);
        Pos3D vRight = new Pos3D(0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.field_71439_g.field_70761_aq, 0.0f);
        Pos3D vCenter = new Pos3D((rand.nextFloat() - 0.5f) * 0.25f, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.field_71439_g.field_70761_aq, 0.0f);
        Pos3D v = playerPos.translate((Vector3d)vLeft).translate((Vector3d)new Pos3D(minecraft.field_71439_g.func_213322_ci()));
        minecraft.field_71452_i.func_199280_a(particle, v.field_72450_a, v.field_72448_b, v.field_72449_c, (double)random, -0.2, (double)random);
        v = playerPos.translate((Vector3d)vRight).translate((Vector3d)new Pos3D(minecraft.field_71439_g.func_213322_ci()));
        minecraft.field_71452_i.func_199280_a(particle, v.field_72450_a, v.field_72448_b, v.field_72449_c, (double)random, -0.2, (double)random);
        if (particleType != JetpackParticleType.HEARTS) {
            v = playerPos.translate((Vector3d)vCenter).translate((Vector3d)new Pos3D(minecraft.field_71439_g.func_213322_ci()));
            minecraft.field_71452_i.func_199280_a(particle, v.field_72450_a, v.field_72448_b, v.field_72449_c, (double)random, -0.2, (double)random);
        }
    }

    public static boolean isFlying(PlayerEntity player) {
        JetpackItem jetpack;
        Item item;
        ItemStack stack = JetpackUtil.getFromBothSlots(player);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof JetpackItem && (jetpack = (JetpackItem)item).isEngineOn(stack) && (jetpack.getEnergy(stack) > 0 || jetpack.isCreative())) {
            if (jetpack.isHoverOn(stack)) {
                return !player.func_233570_aj_();
            }
            return CommonJetpackHandler.isHoldingUp(player);
        }
        return false;
    }

    private static boolean checkValentines() {
        LocalDate today = LocalDate.now();
        int day = today.getDayOfMonth();
        int month = today.getMonthValue();
        return day == 14 && month == 3;
    }
}

